create or replace package body tbicds.PCK_REPORTS is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
/*gets the admission intake id, 
only include intakes that have been reviewed*/
function GetAdmissionIntakeID(pi_nMID in number,
                              pi_vPatientID in varchar2,
                              pi_dtStart in date,
                              pi_dtEnd in date)
  
 return number
 
 is
 
   v_nID number := null;
   
 begin
   
   --mid is not FIM, FIM is handled slightly different
   if pi_nMID != 4042 then 
     
     select intake_id into v_nID 
     from 
          (select di.intake_id 
             from data_intake di
            where di.patient_id = pi_vPatientID 
              and mid = pi_nMID 
              and trunc(di.complete_date) >= pi_dtStart
              and trunc(di.complete_date) <= pi_dtEnd
              
              --intake must be reviewed
              and di.intake_id in (select intake_id 
                                   from pat_pw_event_module em 
                                   where em.patient_id = pi_vPatientID 
                                     and em.pw_event_module_id 
                                     in (select pw_event_module_id 
                                          from pat_pw_event_entry)
                                        )
              
         order by di.complete_date asc
           )
     where rownum = 1; 
   
   else
     
      --FIM MID 4042 intake cannot be FIM goal 
      select intake_id into v_nID 
       from 
            (select di.intake_id 
               from data_intake di
              where di.patient_id = pi_vPatientID 
                and mid = pi_nMID 
                and trunc(di.complete_date) >= pi_dtStart
                and trunc(di.complete_date) <= pi_dtEnd
                
                --intake must be reviewed
                and di.intake_id in (select intake_id 
                                     from pat_pw_event_module em 
                                     where em.patient_id = pi_vPatientID 
                                       and em.pw_event_module_id 
                                       in (select pw_event_module_id 
                                            from pat_pw_event_entry)
                                          )
                
                --FIM MID 4042 intake cannot be FIM goal rid 21
                and ((select rid 
                        from data_intake_responses
                       where intake_id = di.intake_id
                         and tid=1
                         and qid=1) != 21)                     
                
           order by di.complete_date asc
             )
       where rownum = 1; 
    
    end if;
    
    return v_nID;

exception
    when others then
    return null;  
end;

/*gets the value of the most recently answerd impairment q 
within the date range*/                   
function GetImpairmentRID(pi_vPatientID in varchar2,
                          pi_dtEnd in date)
  
 return number
 
 is
 
   v_nID number := null;
   
 begin
   
   select rid into v_nID
    from 
        ( select dir.rid 
           from data_intake_responses_audit dir 
           where dir.mid = 3000 
           and dir.tid=1
           and dir.qid=1
           and dir.patient_id = pi_vPatientID    
           and trunc(dir.complete_date) <= trunc(pi_dtEnd)
           order by dir.complete_date desc
         )
    where rownum=1;

    
    return v_nID;

exception
    when others then
    return null;  
end;

/*gets the value of the most recently answerd injury q 
within the date range*/
function GetInjuryRID(pi_vPatientID in varchar2,
                          pi_dtEnd in date)
  
 return number
 
 is
 
   v_nID number := null;
   
 begin
   
   select rid into v_nID
    from 
        ( select dir.rid 
           from data_intake_responses_audit dir 
           where dir.mid = 3000
           and dir.tid=1
           and dir.qid=4
           and dir.patient_id = pi_vPatientID    
           and trunc(dir.complete_date) <= trunc(pi_dtEnd)
           order by dir.complete_date desc
         )
    where rownum=1;
    
    return v_nID;

exception
    when others then
    return null;  
end;
                       

/*gets the discharge intake id,
only include intakes that have been reviewed*/
function GetDischargeIntakeID(pi_nMID in number,
                              pi_vPatientID in varchar2,
                              pi_dtStart in date,
                              pi_dtEnd in date)
  
 return number
 
 is
 
   v_nID number := null;
   
 begin
   
  --mid is not FIM, FIM is handled slightly different
   if pi_nMID != 4042 then 
  
     select intake_id into v_nID 
     from 
          (select di.intake_id 
             from data_intake di
            where di.patient_id = pi_vPatientID 
              and mid = pi_nMID 
              and trunc(di.complete_date) >= pi_dtStart
              and trunc(di.complete_date) <= pi_dtEnd
              
              --intake must be reviewed
              and di.intake_id in (select intake_id 
                                   from pat_pw_event_module em 
                                   where em.patient_id = pi_vPatientID 
                                     and em.pw_event_module_id 
                                     in (select pw_event_module_id 
                                          from pat_pw_event_entry)
                                        )
                                        
              and (select count(*) 
                   from data_intake di
                  where di.patient_id = pi_vPatientID 
                    and mid = pi_nMID 
                    and trunc(di.complete_date) >= pi_dtStart
                    and trunc(di.complete_date) <= pi_dtEnd 
                    
                    and di.intake_id in (select intake_id 
                                   from pat_pw_event_module em 
                                   where em.patient_id = pi_vPatientID 
                                     and em.pw_event_module_id 
                                     in (select pw_event_module_id 
                                          from pat_pw_event_entry)
                                        )
                    
                    ) > 1
               
         order by di.complete_date desc
           )
     where rownum = 1; 
     
    else
      
      select intake_id into v_nID 
     from 
          (select di.intake_id 
             from data_intake di
            where di.patient_id = pi_vPatientID 
              and mid = pi_nMID 
              and trunc(di.complete_date) >= pi_dtStart
              and trunc(di.complete_date) <= pi_dtEnd
              
              --intake must be reviewed
              and di.intake_id in (select intake_id 
                                   from pat_pw_event_module em 
                                   where em.patient_id = pi_vPatientID 
                                     and em.pw_event_module_id 
                                     in (select pw_event_module_id 
                                          from pat_pw_event_entry)
                                        )
                                        
              --FIM MID 4042 intake cannot be FIM goal rid 21
              and ((select rid 
                        from data_intake_responses
                       where intake_id = di.intake_id
                         and tid=1
                         and qid=1) != 21)   
              
              and (select count(*) 
                   from data_intake di
                  where di.patient_id = pi_vPatientID 
                    and mid = pi_nMID 
                    and trunc(di.complete_date) >= pi_dtStart
                    and trunc(di.complete_date) <= pi_dtEnd 
                    
                    and di.intake_id in (select intake_id 
                                   from pat_pw_event_module em 
                                   where em.patient_id = pi_vPatientID 
                                     and em.pw_event_module_id 
                                     in (select pw_event_module_id 
                                          from pat_pw_event_entry)
                                        )
                    
                    ) > 1
               
         order by di.complete_date desc
           )
     where rownum = 1; 
    
      
    end if;
    
    return v_nID;

exception
    when others then
    return null;  
end;

/*get the followup instrument id,
only include intakes that have been reviewed*/
function GetFollowupIntakeID(pi_nMID in number,
                             pi_vPatientID in varchar2,
                             pi_nDischargeID in number)
  
 return number
 
 is
 
   v_nID number := null;
   v_dtDischarge date := null;
   
 begin
   
   --get the discharge date
   select trunc(d.complete_date) into v_dtDischarge
   from data_intake d  
   where d.patient_id = pi_vPatientID
   and d.intake_id = pi_nDischargeID;
   
   --mid is not FIM, FIM is handled slightly different
   if pi_nMID != 4042 then 
  
     --get the first intake_id after the discharge date
     --call that followup
     select intake_id into v_nID 
     from 
          (select di.intake_id 
             from data_intake di
            where di.patient_id = pi_vPatientID 
              and mid = pi_nMID 
              and trunc(di.complete_date) > v_dtDischarge
              
              --FIM MID 4042 intake cannot be FIM goal rid 21
              and ((select rid 
                        from data_intake_responses
                       where intake_id = di.intake_id
                         and tid=1
                         and qid=1) != 21)  
                         
              --intake must be reviewed
              and di.intake_id in (select intake_id 
                                   from pat_pw_event_module em 
                                   where em.patient_id = pi_vPatientID 
                                     and em.pw_event_module_id 
                                     in (select pw_event_module_id 
                                          from pat_pw_event_entry)
                                        )
                                        
         order by di.complete_date asc
           )
     where rownum = 1; 
  
   else
     
     --get the first intake_id after the discharge date
     --call that followup
     select intake_id into v_nID 
     from 
          (select di.intake_id 
             from data_intake di
            where di.patient_id = pi_vPatientID 
              and mid = pi_nMID 
              and trunc(di.complete_date) > v_dtDischarge
              
              --intake cannot be FIM goal
              --FIM MID 4042 intake cannot be FIM goal rid 21
              and ((select rid 
                        from data_intake_responses
                       where intake_id = di.intake_id
                         and tid=1
                         and qid=1) != 21)  
                         
              --intake must be reviewed
              and di.intake_id in (select intake_id 
                                   from pat_pw_event_module em 
                                   where em.patient_id = pi_vPatientID 
                                     and em.pw_event_module_id 
                                     in (select pw_event_module_id 
                                          from pat_pw_event_entry)
                                        )
                                        
         order by di.complete_date asc
           )
     where rownum = 1; 
  
      
   end if;
    
   return v_nID;

exception
    when others then
    return null;  
end;

/*loads a temp table with population matching criteria*/
procedure LoadPopulation (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_dtFrom                 in date,      
      pi_dtTo                   in date,
      pi_nClinicalSetting       in number,
     
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_nCPAID                 in number,
      
      pi_nImpairmentID          in number,
      pi_nInjuryID              in number,
      pi_nGender                in number,
      pi_nMilStatusID           in number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      )
is

     v_vSQL varchar2(4000) :=
      'insert into report_population(fx_user_id,
                                     patient_id,
                                     initial_date,
                                     end_date)
       select :UserID as fx_user_id,
              t.patient_id,
              t2.initial_date,
              t2.end_date
       from patient_demographics t,
            pat_treatment_program t2
       where t2.patient_id = t.patient_id
       
       and t2.end_date is not null
       and (      trunc(t2.end_date) >= trunc(:DTFROM)
              and trunc(t2.end_date) <= trunc(:DTEND)
            ) 
             
       ';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --delete current cached records for this user
    delete 
    from report_population t 
    where t.fx_user_id = pi_nUserID;
    commit;
    
    --execute the SQL
    EXECUTE IMMEDIATE v_vSQL
    USING pi_nUserID,
          pi_dtFrom,
          pi_dtTo;
         
    
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*get aggregate report given the module group id and mid
population:

pi_dtFrom, pi_dtTo - patients that 
have a pat_treatment initial_date and end_date
within this range (todo: need to look 
at pat_treatmet_programs?)

pi_nClinicalSetting - 1=outpatient, 2=inpatient
patients that have a pat_treatment, treatment_type_id 
matching the clinical setting passed in

region, site, cpa - pat_treatment_program

impairment - data_intake_responses mid 3000 qid 1

injury - data_intake_responses mid 3000 qid 4

gender - patient_demographics

duty status - patient_demographice

*/
procedure GetAggReportRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nModuleGroupID         in number,
      pi_nMID                   in number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'select distinct MID,
                       SERIES,
                       DESCRIPTION,
                       null as ADMISSION,
                       null as DISCHARGE,
                       null as CHANGE1,
                       null as FOLLOWUP,
                       null as CHANGE2
                        
         from DATA_INTAKE_SCORE t
        where t.mid = :MID
         order by t.mid, t.series';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL
    using pi_nMID;
    commit;

    --clear any old data in the population module table
    --from this module
    delete from report_population_module t 
    where t.mid = pi_nMID
    and t.fx_user_id = pi_nUserID;
    commit;
    
    --create records for the mid
    insert into report_population_module(patient_id,
                                         fx_user_id,
                                         initial_date,
                                         end_date,
                                         mid,
                                         admission_intake_id,
                                         discharge_intake_id,
                                         followup_intake_id,
                                         los) 
    select patient_id,
           fx_user_id,
           initial_date,
           end_date,
           pi_nMID,
           null,
           null,
           null,
           null                  
    from report_population pp
    where pp.fx_user_id = pi_nUserID;
    
    commit;   

 --update report_population t 
    --  set t.mid = pi_nMID
    --where t.fx_user_id = pi_nUserID;
    --commit;
    
    --set the admission intake id
    update report_population_module ta
    set ta.admission_intake_id = GetAdmissionIntakeID(ta.mid,
                                                      ta.patient_id,
                                                      ta.initial_date,
                                                      ta.end_date)
         
    where ta.fx_user_id = pi_nUserID
      and ta.mid = pi_nMID;
    commit;                                                     
                      
    --set the discharge intake id
    update report_population_module td 
       set  td.discharge_intake_id = GetDischargeIntakeID(td.mid,
                                                          td.patient_id,
                                                          td.initial_date,
                                                          td.end_date)                                            
                                                     
                                                     
    where td.fx_user_id = pi_nUserID
    and td.mid = pi_nMID;
    commit;                           
        
    
    --set the followup intake id
    update report_population_module tf 
       set  tf.followup_intake_id = GetFollowupIntakeID(tf.mid,
                                                        tf.patient_id,
                                                        tf.discharge_intake_id)                                            
                                                     
                                                     
    where tf.fx_user_id = pi_nUserID
    and tf.mid = pi_nMID;
    commit;   
                               
            
    --now loop and do something to report_population
    --FOR rec IN (SELECT *
    --              FROM report_population t
    --             where t.fx_user_id = pi_nUserID) 
    --LOOP
    --
    --         null;
    --
    --
    --END LOOP;
    

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*get rs of injuries*/
procedure GetInjuryRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'select * from intake_response 
       where mid = 3000 and tid=1 and qid=4 
       order by mid,tid,qid,rid';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*get rs of impairments*/
procedure GetImpairmentRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(4000) :=
      'select * from intake_response 
       where mid = 3000 and tid=1 and qid=1 
       order by mid,tid,qid,rid';
        
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs 
      for v_vSQL;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;



end PCK_REPORTS;
/

